
#|_______________________________________________________________________________
 |
 | Fixes a bug which prevents REGRES, and undoubtedly, other analysis
 | and visualization methods from working. Bug introduced by incompatible
 | changes in vista-scatterplot-proto's isnew method which were made
 | as part of the extensive changes made to define the new plot menu.
 |
 | The next version of the isnew replaces the commented out code following it.
 |
 | The next version was written by fwy on December 26 2002. It allows the "new"
 | version of the isnew (written in early December, 2002) to peacefully coexist
 | with the "old" version, even though they have very different argument structures.
 |
 | They differ in whether the first argument, if there is one, is an integer.
 | The old version always needed an initial integer.  The new version does not.
 |________________________________________________________________________________
 |#

(defmeth vista-scatterplot-proto :isnew (&rest args)
  (cond
    ((and args (integerp (first args)))
     (apply #'call-next-method args)
     (send self :use-color t)
     (send self :plot-buttons :new-x nil :new-y nil :free nil)
     (send self :mouse-mode 'brushing)
     (send self :x-axis t t 5)
     (send self :y-axis t t 5)
     (send self :showing-labels t)
     (send self :legend1 (send current-object :name))
     (send self :legend2 (send self :title))
     )
    (args
     (let* ((keyword-args (rest args))
            (menu-loc)
            (num)
            (selection)
            )
       (when keyword-args
             (setf menu-loc (position ':MENU keyword-args))
             (when menu-loc 
                   (setf num (length keyword-args))
                   (setf selection (remove (1+ menu-loc) (remove menu-loc (iseq num))))
                   (setf keyword-args (select keyword-args selection))))
       (apply #'call-next-method (append (list (length (first args))) keyword-args))
       (apply #'send self :revised-vista-look-and-feel args))
     )
    (t
     (call-next-method 0)
     (apply #'send self :revised-vista-look-and-feel args)
     ))
  self)

(defmeth vista-scatterplot-proto :revised-vista-look-and-feel 
  (&optional data 
        &key variable-labels point-labels
             (container nil) (show t) (top-most t) (pop-out nil)
             (location '(50 50)) (size '(300 300))
             (menu t) (title "Scatterplot") 
             (legend1 (send $ :name)) (legend2 nil)
             (go-away t) (content-only nil))
  ;call-next-method must be done in isnew
  ;(call-next-method (length data) :variable-labels variable-labels
  ;                  :title title :location location :size size 
  ;                  :go-away go-away :show nil :scale-type nil
  ;                  :has-v-scroll nil :has-h-scroll nil)
  (send self :add-points data)
  (send self :use-color t)
  (send self :pop-out-on pop-out)
  (send self :top-most-on top-most)
  (send self :plot-buttons :new-x t :new-y t :free nil :density t)
  (send self :point-color (iseq (send self :num-points)) 'blue)
  (send self :mouse-mode 'brushing)
  (send self :x-axis t t (third (send self :x-axis)))
  (send self :y-axis t t (third (send self :y-axis)))
  (send self :point-label (iseq (send self :num-points)) point-labels)
  (send self :showing-labels t)
  (send self :legend1 (send current-object :name))
  (send self :legend2 (send self :title))
  (send self :adjust-to-data)
  (send self :container container)
  (when show (send self :show-window))
  self)


#|replaced by method below by fwy dec 2002 - before dec 26 2002
(defmeth vista-scatterplot-proto :isnew (&rest args)
  (apply #'call-next-method args)
  (send self :use-color t)
  (send self :plot-buttons :new-x nil :new-y nil :free nil)
  (send self :mouse-mode 'brushing)
  (send self :x-axis t t 5)
  (send self :y-axis t t 5)
  (send self :showing-labels t)
  (send self :legend1 (send current-object :name))
  (send self :legend2 (send self :title))
 ; (send self :pop-out t)
  self)

(defmeth vista-scatterplot-proto :isnew 
  (&optional data 
        &key variable-labels point-labels
             (container nil) (show t) (top-most t) (pop-out nil)
             (location '(50 50)) (size '(300 300))
             (menu t) (title "Scatterplot") 
             (legend1 (send $ :name)) (legend2 nil)
             (go-away t) (content-only nil))
  
  (call-next-method (length data) :variable-labels variable-labels
                    :title title :location location :size size 
                    :go-away go-away :show nil :scale-type nil
                    :has-v-scroll nil :has-h-scroll nil)
  (send self :add-points data)
  (send self :use-color t)
  (send self :pop-out-on pop-out)
  (send self :top-most-on top-most)
  (send self :plot-buttons :new-x t :new-y t :free nil :density t)
  (send self :point-color (iseq (send self :num-points)) 'blue)
  (send self :mouse-mode 'brushing)
  (send self :x-axis t t (third (send self :x-axis)))
  (send self :y-axis t t (third (send self :y-axis)))
  (send self :point-label (iseq (send self :num-points)) point-labels)
  (send self :showing-labels t)
  (send self :legend1 (send current-object :name))
  (send self :legend2 (send self :title))
  (send self :adjust-to-data)
  (send self :container container)
  (when show (send self :show-window))
  self)
|#
